using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class StudiosBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            //
            //StudiosBO
            //
            this.DeleteUsingStoredProcedure = true;
            this.InsertUsingStoredProcedure = true;
            this.RowVersionOrTimestampColumn = "st_Version";
            this.UpdateConcurrencyType = MicroFour.StrataFrame.Data.ConcurrencyTypeOptions.OptimisticRowVersion;
            this.UpdateUsingStoredProcedure = true;

        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[st_pk],[st_Name],[st_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "st_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "Studios";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("st_pk", typeof(System.Int64)),
new DataColumn("st_Name", typeof(System.String)),
new DataColumn("st_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(StudiosBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(StudiosBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int64 st_pk
        {
            get
            {
                return (System.Int64)this.CurrentRow["st_pk"];
            }
            set
            {
                this.CurrentRow["st_pk"] = value;
            }
        }

        /// <summary>
        /// Studio name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Studio name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String st_Name
        {
            get
            {
                return (System.String)this.CurrentRow["st_Name"];
            }
            set
            {
                this.CurrentRow["st_Name"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 st_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["st_Version"];
            }
            set
            {
                this.CurrentRow["st_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum StudiosBOFieldNames
        {
            st_pk,
            st_Name,
            st_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(StudiosBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<StudiosBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<StudiosBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<StudiosBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the StudiosBO class.
        /// </summary>
        static StudiosBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(8);
            _PropertyDescriptors.Add("st_pk", new FieldDescriptor(StudiosBOFieldNames.st_pk, typeof(System.Int64)));
            _PropertyDescriptors.Add("st_Name", new FieldDescriptor(StudiosBOFieldNames.st_Name, typeof(System.String)));
            _PropertyDescriptors.Add("st_Version", new FieldDescriptor(StudiosBOFieldNames.st_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(3);
            _AllFieldsList.Add("st_pk");
            _AllFieldsList.Add("st_Name");
            _AllFieldsList.Add("st_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(3);
            _FieldDbTypes.Add("st_pk", DbType.Int64);
            _FieldDbTypes.Add("st_Name", DbType.AnsiString);
            _FieldDbTypes.Add("st_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(4);
            _FieldEnums.Add("st_pk", StudiosBOFieldNames.st_pk);
            _FieldEnums.Add("st_Name", StudiosBOFieldNames.st_Name);
            _FieldEnums.Add("st_Version", StudiosBOFieldNames.st_Version);
            _FieldEnums.Add("CUSTOM_FIELD", StudiosBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(3);
            _FieldLengths.Add("st_pk", 8);
            _FieldLengths.Add("st_Name", 255);
            _FieldLengths.Add("st_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(3);
            _FieldNativeDbTypes.Add("st_pk", (int)System.Data.SqlDbType.BigInt);
            _FieldNativeDbTypes.Add("st_Name", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("st_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(3);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the StudiosBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<StudiosBOFieldNames>
        {
            public FieldDescriptor(StudiosBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(StudiosBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case StudiosBOFieldNames.st_pk:
                        return ((StudiosBO)component).st_pk;
                    case StudiosBOFieldNames.st_Name:
                        return ((StudiosBO)component).st_Name;
                    case StudiosBOFieldNames.st_Version:
                        return ((StudiosBO)component).st_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case StudiosBOFieldNames.st_pk:
                        ((StudiosBO)component).st_pk = (System.Int64)value;
                        break;
                    case StudiosBOFieldNames.st_Name:
                        ((StudiosBO)component).st_Name = (System.String)value;
                        break;
                    case StudiosBOFieldNames.st_Version:
                        ((StudiosBO)component).st_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
